//
//  GSPathOperator.h
//  PathOperations
//
//  Created by Georg Seifert on 03.03.14.
//  Copyright (c) 2014 Georg Seifert. All rights reserved.
//

#import <Foundation/Foundation.h>

#import <GlyphsCore/GSPathSegment.h>

typedef struct {
	NSPoint results[16];
	uint8 count;
} GSIntersectResultsStruct;

void GSIntersectBezier3Bezier3SegmentsOperations(GSSegmentStruct *P, GSSegmentStruct *Q, GSIntersectResultsStruct *results, int Depth);

@class GSPath;

CGFloat GSMultiplicator(NSPoint a, NSPoint b, NSPoint c);

// checks if all four points are on one line. But make sure to test if the offcurves are between the oncurves.
BOOL GSCubicCollinearish(CGPoint p[4], CGFloat eps);

typedef NS_ENUM(NSInteger, GSPathOperations) {
	GSRemoveOverlap,
	GSSubtract,
};

@interface GSPathOperator : NSObject

+ (BOOL)removeOverlapPaths:(NSMutableArray<GSPath *> *)paths error:(out NSError **)error;
+ (BOOL)removeOverlapPaths:(NSMutableArray<GSPath *> *)paths italicAngle:(CGFloat)italicAngle error:(out NSError **)error;
// + (BOOL)removeOverlapPaths:(NSMutableArray<GSPath *> *)paths1 otherPaths:(NSMutableArray<GSPath *> *)paths2 error:(out NSError **)error;
+ (BOOL)removeOverlapPaths:(NSArray <GSPath *> *)paths intoPen:(NSObject<GSPenProtocol> *)pen error:(out NSError **)error;
+ (BOOL)removeOverlapPaths:(NSArray <GSPath *> *)paths intoPen:(NSObject<GSPenProtocol> *)pen italicAngle:(CGFloat)italicAngle error:(out NSError **)error;
+ (NSMutableArray<GSPathSegment *> *)removeOverlapSegments:(NSArray<GSPathSegment *> *)originalSegments error:(out NSError **)error NS_RETURNS_RETAINED;
+ (BOOL)subtractPaths:(NSArray<GSPath *> *)subtractPaths from:(NSMutableArray<GSPath *> *)paths error:(out NSError **)error;
+ (BOOL)subtractPaths:(NSArray<GSPath *> *)subtractPaths from:(NSMutableArray<GSPath *> *)paths keepOverlaps:(BOOL)keepOverlaps error:(out NSError **)error;
+ (BOOL)intersectPaths:(NSMutableArray<GSPath *> *)subtractPaths with:(NSMutableArray<GSPath *> *)paths error:(out NSError **)error;
+ (NSArray *)segmentsFromPaths:(NSArray<GSPath *> *)paths;
+ (void)addIntersections:(NSMutableArray<GSPathSegment *> *)segments;
+ (void)addIntersections:(NSMutableArray<GSPathSegment *> *)segments otherSegments:(NSMutableArray<GSPathSegment *> *)otherSegments;
@end
